/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.lotr.recipes.api.utils;

import cpw.mods.fml.common.Loader;
import craftedMods.recipes.api.utils.RecipeHandlerUtils;
import craftedMods.recipes.base.AbstractRecipe;
import craftedMods.recipes.base.ShapelessRecipe;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import lotr.client.gui.LOTRGuiAlloyForge;
import lotr.common.item.LOTRItemMug;
import lotr.common.recipe.LOTRBrewingRecipes;
import lotr.common.recipe.LOTRRecipePoisonWeapon;
import lotr.common.recipe.LOTRRecipesTreasurePile;
import lotr.common.tileentity.LOTRTileEntityAlloyForgeBase;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class LOTRRecipeHandlerUtils {
    private static ItemStack[] poison;
    private static List<IRecipe> brewingRecipes;
    private static float[] drinkStrenghts;
    private static Field catalystField;
    private static Field theForgeField;
    private static Field treasureBlockField;
    private static Field ingotItemField;

    public static ItemStack[] getPoison() {
        if (poison == null) {
            ArrayList poisonList = OreDictionary.getOres((String)"poison");
            poison = poisonList.toArray(new ItemStack[poisonList.size()]);
        }
        return poison;
    }

    public static List<IRecipe> getBrewingRecipes() {
        if (brewingRecipes == null) {
            try {
                Field brewingRecipesField = LOTRBrewingRecipes.class.getDeclaredField("recipes");
                brewingRecipesField.setAccessible(true);
                brewingRecipes = (List)brewingRecipesField.get(null);
            }
            catch (Exception e) {
                System.err.print("Couldn't access LOTR brewing recipes: ");
                e.printStackTrace();
            }
        }
        return brewingRecipes;
    }

    public static float[] getDrinkStrenghts() {
        if (drinkStrenghts == null) {
            try {
                Field strenghts = LOTRItemMug.class.getDeclaredField("strengths");
                strenghts.setAccessible(true);
                drinkStrenghts = (float[])strenghts.get(null);
            }
            catch (Exception e) {
                System.err.print("Couldn't access drinkStrengths: ");
                e.printStackTrace();
            }
        }
        return drinkStrenghts;
    }

    public static int getDrinkStrengthIndex(float strength) {
        int index = 0;
        float[] strengths = LOTRRecipeHandlerUtils.getDrinkStrenghts();
        for (int i = 0; i < strengths.length; ++i) {
            if (strengths[i] != strength) continue;
            index = i;
            break;
        }
        return index;
    }

    public static AbstractRecipe processPoisonWeaponRecipe(LOTRRecipePoisonWeapon poisonRecipe) {
        try {
            if (catalystField == null) {
                catalystField = LOTRRecipePoisonWeapon.class.getDeclaredField("catalystObj");
                catalystField.setAccessible(true);
            }
            ArrayList<Object> ingredients = new ArrayList<Object>();
            ingredients.add(poisonRecipe.getInputItem());
            ingredients.add(RecipeHandlerUtils.getInstance().extractRecipeItems(catalystField.get(poisonRecipe)));
            return new ShapelessRecipe(ingredients, poisonRecipe.func_77571_b());
        }
        catch (Exception e) {
            System.err.print("Couldn't load the poisoned weapon recipe: ");
            e.printStackTrace();
            return null;
        }
    }

    public static LOTRTileEntityAlloyForgeBase getAlloyForge(LOTRGuiAlloyForge gui) {
        try {
            if (theForgeField == null) {
                theForgeField = LOTRGuiAlloyForge.class.getDeclaredField("theForge");
                theForgeField.setAccessible(true);
            }
            return (LOTRTileEntityAlloyForgeBase)((Object)theForgeField.get((Object)gui));
        }
        catch (Exception e) {
            System.err.print("Couldn't load the poisoned weapon recipe: ");
            e.printStackTrace();
            return null;
        }
    }

    public static String getUnlocalizedEntityName(Class<?> entityClass) {
        return EntityList.field_75626_c.get(entityClass).toString().replace("lotr.", "");
    }

    public static Pair<Block, Item> getTreasurePileRecipeItems(LOTRRecipesTreasurePile recipe) {
        try {
            if (treasureBlockField == null || ingotItemField == null) {
                treasureBlockField = LOTRRecipesTreasurePile.class.getDeclaredField("treasureBlock");
                ingotItemField = LOTRRecipesTreasurePile.class.getDeclaredField("ingotItem");
                treasureBlockField.setAccessible(true);
                ingotItemField.setAccessible(true);
            }
            return Pair.of((Object)((Block)treasureBlockField.get(recipe)), (Object)((Item)ingotItemField.get(recipe)));
        }
        catch (Exception e) {
            System.err.print("Couldn't load the poisoned weapon recipe: ");
            e.printStackTrace();
            return null;
        }
    }

    public static boolean hasMtLotr() {
        return Loader.isModLoaded((String)"mt-lotr");
    }
}

